#include <mega32.h>
#include <delay.h>

#define yekan PORTC
#define dahgan PORTD
#define sadgan PORTB

void main(){
    int value;
    long V;
    char str[10]={0x3f,0x06,0x5b,0x4f,0x66,0x6d,0x7d,0x07,0x7f,0x6f}; // codes for 7seg cathode
    DDRA=PORTA=0x00;
    DDRB=DDRD=DDRC=0xff;
    yekan=dahgan=sadgan=0x00;
    ADMUX = 0b01000000;
    while(1)
    {
        ADCSRA = 0b11000000;
        while(ADCSRA.4 ==0);
        V = ((ADCW) * 390.2837209302326 / 1051.7818)-53;
        ADCSRA.4 = 1;
        value=(int)V;

        if (value<0) value=0;
        else if (value>300) value=300;

        yekan=dahgan=sadgan=0x00; //turn off all 7 segment

        yekan=str[value%10];
        dahgan=str[(value/10)%10];
        sadgan=str[(value/100)%10];

        delay_ms(35);
    }
}